//Only remove stars when we exit district. Maybe save the stars in each district?
@replaceMethod(PreventionSystem)
  private final func OnRefreshDistrict(request: ref<RefreshDistrictRequest>) -> Void {
    if !IsDefined(request.preventionPreset) {
      this.RestoreDefaultPreset();
    } else {
	  if this.m_preventionPreset!=request.preventionPreset{
		//this.execInstructionSafeVC();
	  };
      this.m_preventionPreset = request.preventionPreset;
	 
    };
    if !IsFinal() {
      this.RefreshDebugDistrictInfo();
    };
  }
@addMethod(PreventionSystem)
  private final func execInstructionSafeVC() -> Void {
    if !this.IsChasingPlayer() {
      return;
    };
    if this.m_player.IsInCombat(){
		return;
	};
    this.m_systemDisabled = false;
    this.WhipeBlinkData();
    //this.ChangeAgentsAttitude(EAIAttitude.AIA_Neutral); Make them stay hostile if you go back to their area
    this.WakeUpAllAgents(false);
    this.WhipeHitNPC();
    this.DespawnAllPolice();
    this.RemovePlayerFromSecuritySystemBlacklist();
    this.CancelAllDelayedEvents();
    this.m_generalPercent = 0.00;
    if this.SetHeatStage(EPreventionHeatStage.Heat_0) {
      this.OnHeatChanged();
    };
	
	//Reenable maxtac for next round
	this.maxtacSpawned=false;
  }
  
//Disable old way as opposed to removing all instances of it being called
@replaceMethod(PreventionSystem)
  private final func execInstructionSafe() -> Void {
	this.execInstructionSafeVC();
	return;
  }

@replaceMethod(PreventionSystem)
  private final func OnDeescalationZero(evt: ref<PreventionDelayedZeroRequest>) -> Void {
    if ArraySize(this.m_viewers) > 0 {
      this.ResetDeescalationZero();
      return;
    };
    this.execInstructionSafeVC();
    if !IsFinal() {
      this.RefreshDebugEvents();
    };
  }


